<?php

namespace addons\smsyunpian\library;

/**
 * 短信发送
 */
class SmsYunpian
{
    private $_params = [];
    public $error = '';
    protected $config = [];
    function get_text($code){
        $config = get_addon_config('smsyunpian');
        $text=$config["text"];
        
        $text=str_replace("#code#", $code, $text);
        return $text;
        
        
    }

    /**
     * 立即发送
     * @return boolean
     */
    public function send($mobile="",$code="")
    {
        $this->error = '';
        $config = get_addon_config('smsyunpian');
         $params = [
                'apikey' => $config["apikey"],
                'mobile' => $mobile,
                'text' => $this->get_text($code),
                ];
      
        $response = $this->_curl($params);
        // dump($response);die();
        if ($response !== false) {
            $res = (array)json_decode($response, true);
            if (isset($res['code']) && $res['code'] == '0') {
                return true;
            }
            $this->error = isset($res['msg']) ? $res['msg'] : 'SmsYunpian_InvalidResult';
        } else {
            $this->error = 'InvalidResult';
        }
        return false;
    }

    /**
     * 获取错误信息
     * @return string
     */
    public function getError()
    {
        return $this->error;
    }


    private function _curl($params)
    {
      
        // dump($uri);
        $ch = curl_init();
        $headers = [
            'Accept: text/plain;charset=utf-8;',
            'Content-Type: application/x-www-form-urlencoded;charset=utf-8;',
        ];
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        
        /* 设置通信方式 */
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_URL, 'https://sms.yunpian.com/v2/sms/single_send.json');
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($params));
        $result = curl_exec($ch);
        curl_close($ch);
        return $result;
         
    }
}
